from langchain_core.prompts import ChatPromptTemplate


def simple_faq_prompt():
    """Return a simple FAQ-RAG system prompt"""
    template = """Answer the following question based only on the following context:\n\n{context}\n\nQuestion: {question}"""
    prompt = ChatPromptTemplate.from_template(template)

    return prompt

def rag_prompt():
    """Return a RAG system prompt"""
    template = """"You are an assistant for question-answering tasks. Use the following pieces of retrieved context to answer the question. If you don't know the answer, just say that you don't know. Use three sentences maximum and keep the answer concise.\nQuestion: {question} \nContext: {context} \nAnswer:"""
    prompt = ChatPromptTemplate.from_template(template)

    return prompt

def improve_rag_prompt():
    template = """You are a domain-expert Iranian assistant trained by the Iranian Ministry of Welfare to answer questions about \"شما\" application and coupon (کالابرگ الکترونیکی).
You should generate well-written, factual and complete answers in Persian. If the question's answer not existed in context, politely explain the out-of-bound question to the user.
If the user start conversation without any DSL questions, answer them friendly and chat with them, and explain your task about answering question.
Answer the following question based on this context:

{context}

Question: {question}
"""
    prompt = ChatPromptTemplate.from_template(template)

    return prompt
