from langchain_chroma import Chroma


def init_vector_store(splits, embedding_model, persist_directory: str, k_arg: int):
    """Initializing the Chroma vector store and return it as retriever"""
    vector_store = Chroma.from_documents(documents=splits, embedding=embedding_model, persist_directory=persist_directory)
    retriever = vector_store.as_retriever(search_kwargs={"k": k_arg})

    return retriever

def get_vector_store(persist_directory: str, embedding_model, k_arg: int):
    """Get the existed Chroma vector store and return it as retriever"""
    vector_store = Chroma(persist_directory=persist_directory, embedding_function=embedding_model)
    retriever = vector_store.as_retriever(search_kwargs={"k": k_arg})

    return retriever

def init_vector_store_list(embedding_model, persist_directory: str, collection_name: str,
                           texts: list, ids: list, metadatas: list, k_arg: int):
    client = Chroma(collection_name=collection_name, embedding_function=embedding_model,
                    persist_directory=persist_directory)

    client.add_texts(texts=texts, ids=ids, metadatas=metadatas)
    retriever = client.as_retriever(search_kwargs={"k": k_arg})

    return retriever

def get_vector_store_list(embedding_model, persist_directory: str, collection_name: str, k_arg: int):
    client = Chroma(collection_name=collection_name, embedding_function=embedding_model,
                    persist_directory=persist_directory)
    retriever = client.as_retriever(search_kwargs={"k": k_arg})

    return retriever
